<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AGS Akademiye Giriş Sınavı Admin</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- FontAwesome -->
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWix+LLJAJ9/2PkPKZ5QiAj6Ta86w+pjO4AyZfssCG0+Pv+3zdeQia/Aq92N0UDKGS9k imperatives!" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Custom CSS -->
    <style>
        body {
            padding-top: 56px; /* Navbar yüksekliği kadar boşluk bırak */
        }
        .sidebar {
            position: fixed;
            top: 56px; /* Navbar'ın altından başla */
            bottom: 0;
            left: 0;
            z-index: 1000;
            padding: 10px 0;
            box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
            overflow-y: auto; /* Dikey kaydırma çubuğu */
        }
        .sidebar .nav-link {
            font-weight: 500;
            color: #333;
        }
        .sidebar .nav-link.active {
            color: #0d6efd;
        }
        .sidebar .nav-link:hover {
            color: #0d6efd;
        }
        .main-content {
            margin-left: 200px; /* Sidebar genişliği kadar boşluk bırak */
            padding-top: 20px;
        }
        /* Toast Bildirimleri İçin CSS */
        .toast-container {
            position: fixed;
            bottom: 1.5rem;
            right: 1.5rem;
            z-index: 1090; /* Bootstrap modal Z-index'inden yüksek */
        }
    </style>
     <?php
        // Oturum mesajını JavaScript'e aktar
        $session_message = get_session_message();
        if ($session_message) {
            // JSON olarak encode ederken, HTML özel karakterlerini koru ve tek tırnak sorununu çöz
             $message_json = json_encode($session_message, JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_HEX_TAG);
             // Güvenlik için <script> etiketi içinde doğrudan echo yerine veri özelliğine basılabilir
            //  echo '<script type="text/javascript"> const sessionMessage = ' . $message_json . ';</script>';
            // Alternatif ve daha güvenli yol: body etiketine data attribute eklemek (veya gizli bir div)
            echo '<div id="session-message-data" data-message=' . htmlspecialchars($message_json, ENT_QUOTES, 'UTF-8') . ' style="display: none;"></div>';
        }
    ?>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">AGS Admin</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">Çıkış Yap</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <div class="container-fluid">
        <div class="row">
            <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" aria-current="page" href="index.php">
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">
                                Kategoriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="subcategories.php">
                                Alt Kategoriler
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="question_packages.php">
                                Soru Paketleri
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="question_answers.php">
                                Soru-Cevaplar
                            </a>
                        </li>
                         <li class="nav-item">
                            <a class="nav-link" href="users.php">
                                Kullanıcılar
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                Raporlar
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 main-content">
                <!-- İçerik burada yüklenecek --> 