<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/SubcategoryService.php';

header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Geçersiz istek.'];

if (isset($_GET['categoryId'])) {
    $categoryId = intval($_GET['categoryId']);
    $subcategoryService = new SubcategoryService($conn);
    
    if ($categoryId > 0) {
        $subcategories = $subcategoryService->getSubcategoriesByCategoryId($categoryId);
        $response = ['status' => 'success', 'subcategories' => $subcategories];
    } else {
        // Eğer categoryId 0 ise (Tüm Kategoriler seçeneği gibi), tüm alt kategorileri döndürebiliriz
        $subcategories = $subcategoryService->getAllSubcategoriesWithCategoryNames(); // Tüm alt kategorileri getirsin
        $response = ['status' => 'success', 'subcategories' => $subcategories];
    }
}

echo json_encode($response);
?> 