<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/CategoryService.php';
require_once __DIR__ . '/../config.php'; // API_KEY için

header('Content-Type: application/json; charset=UTF-8');

if (!isset($_SERVER['HTTP_X_API_KEY']) || $_SERVER['HTTP_X_API_KEY'] !== API_KEY) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Yetkisiz erişim.']);
    exit();
}

$categoryService = new CategoryService($conn);

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            $id = intval($_GET['id']);
            $category = $categoryService->getCategoryById($id);
            if ($category) {
                echo json_encode(['status' => 'success', 'data' => $category]);
            } else {
                http_response_code(404);
                echo json_encode(['status' => 'error', 'message' => 'Kategori bulunamadı.']);
            }
        } else {
            $categories = $categoryService->getAllCategories();
            echo json_encode(['status' => 'success', 'data' => $categories]);
        }
        break;
    
    // API endpointleri için POST, PUT, DELETE gibi metotlar da eklenebilir
    // Ancak admin panelinden yönetildiği için şimdilik sadece GET yeterlidir.

    default:
        http_response_code(405);
        echo json_encode(['status' => 'error', 'message' => 'Desteklenmeyen istek metodu.']);
        break;
}

$conn->close();
?> 