<?php

require_once __DIR__ . '/../db_connect.php';

class FcmService {
    private $conn;
    private $FCM_SERVER_KEY = "AIzaSyAyupGp1BBFcYPhsuSrLduzwB9__Ymuo1A"; // Firebase Console'dan alınan anahtar

    public function __construct($db_conn) {
        $this->conn = $db_conn;
    }

    public function registerToken($fcmToken) {
        // Token zaten varsa güncelle, yoksa ekle
        $stmt = $this->conn->prepare("INSERT INTO fcm_tokens (fcm_token) VALUES (?) ON DUPLICATE KEY UPDATE created_at = CURRENT_TIMESTAMP");
        $stmt->bind_param("s", $fcmToken);
        if ($stmt->execute()) {
            return true;
        } else {
            error_log("FCM token kaydedilirken hata: " . $stmt->error);
            return false;
        }
    }

    public function getAllTokens() {
        $sql = "SELECT fcm_token FROM fcm_tokens";
        $result = $this->conn->query($sql);
        $tokens = [];
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $tokens[] = $row['fcm_token'];
            }
        }
        return $tokens;
    }

    public function deleteToken($fcmToken) {
        $stmt = $this->conn->prepare("DELETE FROM fcm_tokens WHERE fcm_token = ?");
        $stmt->bind_param("s", $fcmToken);
        if ($stmt->execute()) {
            return true;
        } else {
            error_log("FCM token silinirken hata: " . $stmt->error);
            return false;
        }
    }

    public function sendNotification($title, $body, $data = []) {
        $registrationIds = $this->getAllTokens();

        if (empty($registrationIds)) {
            error_log("Hiçbir FCM token kayıtlı değil. Bildirim gönderilemedi.");
            return false;
        }

        $url = 'https://fcm.googleapis.com/fcm/send';

        $fields = array(
            'registration_ids' => $registrationIds,
            'notification' => array('title' => $title, 'body' => $body),
            'data' => $data // Ekstra veriler
        );

        $headers = array(
            'Authorization: key=' . $this->FCM_SERVER_KEY,
            'Content-Type: application/json'
        );

        // cURL ile FCM'ye istek gönder
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        $result = curl_exec($ch);

        if ($result === FALSE) {
            error_log("FCM bildirim gönderirken cURL hatası: " . curl_error($ch));
            curl_close($ch);
            return false;
        }

        curl_close($ch);

        $response = json_decode($result, true);
        
        // Hata ayıklama için yanıtı logla
        error_log("FCM Bildirim Yanıtı: " . json_encode($response));

        // Başarısız olan tokenları sil
        if (isset($response['results'])) {
            foreach ($response['results'] as $index => $res) {
                if (isset($res['error'])) {
                    // Örneğin, 'NotRegistered' hatası varsa token'ı sil
                    if ($res['error'] === 'NotRegistered' || $res['error'] === 'InvalidRegistration') {
                        $this->deleteToken($registrationIds[$index]);
                        error_log("Geçersiz veya kayıtlı olmayan FCM token silindi: " . $registrationIds[$index]);
                    }
                }
            }
        }

        return $response;
    }
}
?> 