<?php
require_once __DIR__ . '/../helpers/session_helper.php';
require_once __DIR__ . '/../db_connect.php'; // VT bağlantısı
require_once __DIR__ . '/../services/QuestionAnswerService.php'; // Sayım metotları burada
// Diğer Service sınıflarını da dahil edebilirsiniz eğer sayım metotları oradaysa (CategoryService, UserService vb.)

check_admin_session(); // Admin oturumunu kontrol et

$questionAnswerService = new QuestionAnswerService($conn); // Service sınıfını başlat

// Toplam sayıları al
$totalQuestions = $questionAnswerService->getTotalQuestionAnswersCount();
$totalPackages = $questionAnswerService->getTotalQuestionPackagesCount();
$totalCategories = $questionAnswerService->getTotalCategoriesCount();
$totalSubcategories = $questionAnswerService->getTotalSubcategoriesCount();
$totalUsers = $questionAnswerService->getTotalUsersCount(); // Eğer UserService varsa oradan çekilmeli

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Dashboard</h1>
<?php display_session_message(); // Oturum mesajlarını göster ?>

<div class="alert alert-info" role="alert">
    AGS Akademiye Giriş Sınavı Yönetim Paneline hoş geldiniz!
</div>

<!-- İstatistik Kartları -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary mb-3">
            <div class="card-header">Toplam Soru</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $totalQuestions; ?></h5>
                <p class="card-text">Sistemdeki toplam soru sayısı.</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success mb-3">
            <div class="card-header">Toplam Paket</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $totalPackages; ?></h5>
                <p class="card-text">Sistemdeki toplam soru paketi sayısı.</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning mb-3">
            <div class="card-header">Toplam Kategori</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $totalCategories; ?></h5>
                <p class="card-text">Sistemdeki toplam kategori sayısı.</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info mb-3">
            <div class="card-header">Toplam Alt Kategori</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $totalSubcategories; ?></h5>
                <p class="card-text">Sistemdeki toplam alt kategori sayısı.</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger mb-3">
            <div class="card-header">Toplam Kullanıcı</div>
            <div class="card-body">
                <h5 class="card-title"><?php echo $totalUsers; ?></h5>
                <p class="card-text">Sistemdeki toplam kullanıcı sayısı.</p>
            </div>
        </div>
    </div>
</div>

<!-- Navigasyon Kartları -->
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Kategoriler</h5>
                <p class="card-text">Kategorileri yönetin.</p>
                <a href="categories.php" class="btn btn-primary">Git</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Alt Kategoriler</h5>
                <p class="card-text">Alt kategorileri yönetin.</p>
                <a href="subcategories.php" class="btn btn-primary">Git</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Soru Paketleri</h5>
                <p class="card-text">Soru paketlerini yönetin.</p>
                <a href="question_packages.php" class="btn btn-primary">Git</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Soru-Cevaplar</h5>
                <p class="card-text">Soru-cevapları yönetin.</p>
                <a href="question_answers.php" class="btn btn-primary">Git</a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Kullanıcılar</h5>
                <p class="card-text">Kullanıcıları yönetin.</p>
                 <a href="users.php" class="btn btn-primary">Git</a>
            </div>
        </div>
    </div>
</div>

<?php include '_footer.php'; // Footer'ı dahil et ?> 